package gov.va.med.mhv.sm.admin.jpa.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import gov.va.med.mhv.sm.admin.jpa.model.AbstractBaseEntity;

@Entity
@Table(name = "FACILITIES")
@DynamicUpdate(value = true)
@SelectBeforeUpdate(value = true)
public class Facility extends AbstractBaseEntity {

	private static final long serialVersionUID = 713904806128639016L;

	@Id
	@Column(name = "ID", insertable = false, updatable = false)
	private Long id;

	@Column(name = "PARENT_ID", insertable = false, updatable = false)
	private String parentId;
	
	@Column(name = "VISTANAME", insertable = false, updatable = false)
	private String name;

	@Column(name = "STATIONNUMBER", insertable = false, updatable = false)
	private String stationNumber;
	

	@Column(name = "VISN_ID", insertable = false, updatable = false)
	private String visnId;

	public Facility() {
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getVisnId() {
		return visnId;
	}

	public void setVisnId(String visnId) {
		this.visnId = visnId;
	}


}
